<?php

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("postbit", "imagebirthday_profile");
$plugins->add_hook("showthread_start","imagebirthday_profile");
$plugins->add_hook("showthread_end","imagebirthday_profile");



function imagebirthday_info()
{
	/**
	 * Array of information about the plugin.
	 * name: The name of the plugin
	 * description: Description of what the plugin does
	 * website: The website the plugin is maintained at (Optional)
	 * author: The name of the author of the plugin
	 * authorsite: The URL to the website of the author (Optional)
	 * version: The version number of the plugin
	 * guid: Unique ID issued by the MyBB Mods site for version checking
	 * compatibility: A CSV list of MyBB versions supported. Ex, "121,123", "12*". Wildcards supported.
	 */
	return array(
		'name'			=> 'هاك عيد ميلاد العضو',
		'description'	=> 'يقوم باضافة صورة تهنيئة بعيد ميلاد العضو داخل الموضوع',
		'website'		=> 'http://www.collectiontricks.it',
		"author"		=> 'Asterix',
		'authorsite'	=> 'http://collectiontricks.it',
		'version'    	=> "1.2",
		'guid' 			=> '7fc546fce0207425e72a3f9e80dd3669',
		'compatibility' => '16*'
	);
}

function imagebirthday_activate()
{
 global $mybb, $db, $theme;

    $query = $db->simple_select('settinggroups', 'COUNT(*) as rows');
	$rows  = $db->fetch_field($query, 'rows');

	// definizione del gruppo setting
	
	$insertArray = array('name' => 'ImageBirthday',
                         'title' => 'هاك عيد ميلاد العضو',
	                     'description' => 'اعدادات هاك عيد ميلاد العضو ',
	                     'disporder' => $rows + 1,
	                     'isdefault'   => 0
	                     );

    $group['gid'] = $db->insert_query('settinggroups', $insertArray);

	// definizione variabili di configurazione plugin

	$insertArray = array('name' => 'ImagebirthdayPath',
	                     'title' => 'مسار صورة التهنئه',
	                     'description' => '',
	                     'optionscode' => 'text',
	                     'value' => 'images/happy.gif',
	                     'disporder' => 0,
	                     'gid' => $group['gid']
	                     );

	$db->insert_query('settings', $insertArray);
	

	rebuild_settings(); 
	
	require MYBB_ROOT.'/inc/adminfunctions_templates.php';
  
	find_replace_templatesets("postbit", "#".preg_quote('{$post[\'message\']}')."#i", '{$post[\'msgbirth\']}{$post[\'message\']}');
	find_replace_templatesets("postbit_classic", "#".preg_quote('{$post[\'message\']}')."#i", '{$post[\'msgbirth\']}{$post[\'message\']}');
	

	
}


function imagebirthday_deactivate()
{
 global $mybb, $db, $theme;
 
 
	// pulizia tabelle settinggroups e setting
	
 $db->delete_query('settinggroups', 'name = \'ImageBirthday\'');
 $db->delete_query('settings', "name IN ('ImagebirthdayPath')");

 rebuild_settings();
 
 require MYBB_ROOT.'/inc/adminfunctions_templates.php';
 find_replace_templatesets("postbit", '#'.preg_quote('{$post[\'msgbirth\']}').'#', '', 0);
 find_replace_templatesets("postbit_classic", '#'.preg_quote('{$post[\'msgbirth\']}').'#', '', 0);
}

function imagebirthday_profile(&$post)
{
	global $global, $forum,  $mybb, $db;
 
	$bday = explode("-", $post['birthday']);
	if(!$bday[2])
	{
		return;
	}

	list($day, $month, $year) = explode("-", my_date("j-n-Y", TIME_NOW, 0, 0));



if($month == $bday[1] && $day == $bday[0])
	{
		$file = $mybb->settings['bburl'].'/'.$mybb->settings['ImagebirthdayPath'].' border=0 align=right';
		$post['msgbirth']= "<img src=".$file.">";
	} 
  
}


?>
